/**
 * @file ucprobe.c
 * @date 2017-06-26
 *
 * NOTE:
 * This file is generated by DAVE-4. Any manual modification done to this file will be lost when the code is regenerated.
 *
 * @cond
 ***********************************************************************************************************************
 * UCPROBE v4.0.4 - Configures UCPROBE target code
 * Copyright (c) 2015-2017, Infineon Technologies AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the
 * following conditions are met:
 *
 *   Redistributions of source code must retain the above copyright notice, this list of conditions and the  following
 *   disclaimer.
 *
 *   Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the
 *   following disclaimer in the documentation and/or other materials provided with the distribution.
 *
 *   Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote
 *   products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes
 * with Infineon Technologies AG (dave@infineon.com).
 ***********************************************************************************************************************
 *
 * Change History
 * --------------
 *
 * 2016-07-30:
 *     - Initial version<br>
 *
 * @endcond
 *
 */


/***********************************************************************************************************************
 * HEADER FILES
 **********************************************************************************************************************/
#include "ucprobe.h"
#include "probe_rs232.h"
#include "probe_scope.h"
#include "probe_scope_cfg.h"

/***********************************************************************************************************************
 * PRIVATE FUNCTION PROTOTYPES
 **********************************************************************************************************************/

/**********************************************************************************************************************
 * API IMPLEMENTATION
 **********************************************************************************************************************/

/* API to retrieve App version info */
DAVE_APP_VERSION_t UCPROBE_GetAppVersion(void)
{
  DAVE_APP_VERSION_t version;

  version.major = UCPROBE_MAJOR_VERSION;
  version.minor = UCPROBE_MINOR_VERSION;
  version.patch = UCPROBE_PATCH_VERSION;

  return (version);
}

/* API to initialize UC/Probe support */
void UCPROBE_Init(void)
{
#if UCPROBE_PROBESCOPE_EN
  ProbeScope_Init(PROBE_SCOPE_SAMPLING_CLK_HZ_DFLT);
#endif

#if (PROBE_COM_CFG_RS232_EN == DEF_ENABLED)
  ProbeCom_Init(); /* Initialize the Generic module */
  ProbeRS232_Init(UCPROBE_UART_BAUD_RATE); /* Initialize the RS-232 interface */
  ProbeRS232_RxIntEn(); /* Initialize the RS-232 Rx interrupts */
#endif
}

/* end of UCPROBE function definitions */

